// Adapted from the RenderMonkey HDR sample

uniform sampler2D canvas;

float scale = 1.0 / 256.0;

vec4 gaussFilter[7];

void main(void)
{
  vec4 color = vec4(0.0);
  vec2 coord = gl_TexCoord[0].st;
  
  gaussFilter[0] = vec4(-3.0, 0.0, 0.0,  5.0 / 54.0);
  gaussFilter[1] = vec4(-2.0, 0.0, 0.0,  7.0 / 54.0);
  gaussFilter[2] = vec4(-1.0, 0.0, 0.0, 10.0 / 54.0);
  gaussFilter[3] = vec4( 0.0, 0.0, 0.0, 15.0 / 54.0);
  gaussFilter[4] = vec4( 1.0, 0.0, 0.0, 10.0 / 54.0);
  gaussFilter[5] = vec4( 2.0, 0.0, 0.0,  7.0 / 54.0);
  gaussFilter[6] = vec4( 3.0, 0.0, 0.0,  5.0 / 64.0);
  
  for (int i = 0;  i < 7;  i++)
  {
    color += texture2D(canvas, vec2(coord.s + gaussFilter[i].s * scale,
                                    coord.t + gaussFilter[i].t * scale)) * 
             gaussFilter[i].q;
  }
  
  gl_FragColor = color;
}

